
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class School : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.School, BO.School>
    {

        internal School(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal School(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.School.DBD) { }

        internal BO.School RestoreTopOne(BO.School.Search Search)
        {
            return InternalRestoreOne((int)DBD.School.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["ID"].Value = Search.ID;
                Command["Name"].Value = Search.Name;
                Command["Address"].Value = Search.Address;
                Command["Town"].Value = Search.Town;
            });
        }

        internal List<BO.School> Restore(BO.School.Search Search)
        {
            return InternalRestoreList((int)DBD.School.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["ID"].Value = Search.ID;
                Command["Name"].Value = Search.Name;
                Command["Address"].Value = Search.Address;
                Command["Town"].Value = Search.Town;
            });
        }
    }
}
